# JDBC Readme

This folder contains examples which shows how you can use the database backend.

## DatabaseClassUsableInDesigner

This sample shows how to define a Database class that can be used for report design and report execution. This class defines one table with three string columns, that will be shown in i-net Designer - Visual Database Wizard. This sample also demonstrates the usage of the public class com.inet.report.DatabaseMetaDataFactory that is helpful to create meta data Result Sets expected from i-net Designer.

[Click to open the sample file.](jdbc/DatabaseClassUsableInDesigner.java)

## DataWithExternalResultSet.java

With this database class it is possible to set the report data with an external Result Set instead of using a connection to a database created by i-net Clear Reports.

[Click to open the sample file.](jdbc/DataWithExternalResultSet.java)

## DataWithoutJDBC.java

Shows how to use the getReportData() callback of the Database class to set the report data instead of using a JDBC database connection.

[Click to open the sample file.](jdbc/DataWithoutJDBC.java)

## EngineSetConnection.java

Shows you how you can set an external database connection that will be used to fetch the report data instead of the database that was specified at design time.

[Click to open the sample file.](jdbc/EngineSetConnection.java)

## MainAndSubreportDataWithExternalResultSet.java

With this database class it is possible to set the data for main and sub-report with an external Result Set instead of using a connection to a database created by i-net Clear Reports.

[Click to open the sample file.](jdbc/MainAndSubreportDataWithExternalResultSet.java)

## ReportBasedOnSQLCommand.java

This sample class shows how to create a report that is based on a SQL command.

[Click to open the sample file.](jdbc/ReportBasedOnSQLCommand.java)

## ReportBasedOnStoredProcedure.java

This sample class shows how to create a report that is based on a stored procedure with two input parameters.

[Click to open the sample file.](jdbc/ReportBasedOnStoredProcedure.java)

